<script>

   function ViewManager(){
         var self=this;
         this.server="<?php echo Config::get('URL'); ?>";
         this.inspectionversion=<?php echo $this->inspectionversion;?>;
         this.currentView="";
         this.currentMedia="";
         this.pods=new Array();
         this.selectedPod=null;
         this.selectedSegment=null;
         this.viewid=1;
         this.vector = Raphael(document.getElementById("vector"));
         this.rm=new ResourceManager(bucketReady);

         $('.view button').click(function(){
            self.viewid=$(this).index()+1;
            self.loadView($(this).html().toLowerCase(),this);
         })
        this.deletePod=function (pod){
           $(pod.pod).remove();
           if(pod.line)pod.line.remove();
           for(i=0;i<self.pods.length;i++){
              if(self.pods[i]==pod){
                 self.pods.splice(i,1);
                 return;
              }
           }
           return;
        }
        this.clearAll=function(){
           for(i=self.pods.length-1;i>-1;i--)self.deletePod(self.pods[i]);
           self.selectedPod=null
        }

        this.openViewer=function(){
          if(vm.currentMedia.toLowerCase().indexOf('.pdf')!=-1){
            Shadowbox.open({
                content:    vm.currentMedia,
                player:     "iframe",
                title:      "",
                height:     600,
                width:      1200
            });
          }
          else{
          try{
            Shadowbox.open({
                content:    vm.currentMedia,
                player:     "img",
                title:      ""
            });
          }
          catch(e){
              alert(e);
          }
          }

        }


        this.loadView=function(view,caller){
           var server=self.server;
           self.clearAll();
           $('#resource,#_ref,#_title').empty();
           $('#description').empty();
           $('#indicator').css({background:'transparent'});

           $.post('<?php echo Config::get('URL'); ?>hms/getviewbytype',{'type':'safety','view':view,'version':self.inspectionversion},function(data){
              var image=self.rm.getResource(data.image);
              $('#viewimage').val(data.image);
              $('#vector').css({'background-image':'url('+image+')'});
              var c=0;
              for(i in data.pods){
                 if(c<data.pods.length){
                    var p=new pod(document.getElementById("bitmap"),data.pods[i],self.server,c);
                    self.pods.push(p);
                    p.deserialize();
                    var currentViewtype="safety";
                    p.changeViewType(currentViewtype);
                    c++;
                 }
              }
              $('.view button').css('color','#B6B3AA');
              $(caller).css('color','#66CC33');
          },"json");
          self.currentView=view;
        }
   }
   var vm;

   $(document).ready(function(){
      vm=new ViewManager();
   })

   function bucketReady(){
      $('.view button:first').trigger('click');
   }

</script>

<div id="workspace" style="width:1100px">
   <div class="view" align="left" style="position:absolute;top:263px;">
      <button>Left</button>
      <button>Right</button>
      <button>Front</button>
      <button>Rear</button>
      <button>Plan</button>
      <button>Underside</button>
   </div>
   <div id="both">
      <div id="vector" style="position:absolute;top:285px;width:623px;height:346px;">
      </div>
      <div id="bitmap" style="position:absolute;top:285px;width:623px;height:346px">
      </div>
   </div>
   <div id="resourcetitle" style="position:absolute;top:263px;margin-left:640px;">
      <span class="zoom">
         <div id="indicator" style="width:18px;height:17px;border:1px solid #B6B3AA;float:left">
         </div>&nbsp;&nbsp;
         <span id="_title" style="width:330px;height:17px;background-color:transparent;color:#B6B3AA;font:11px arial,sans-serif;border:1px solid #transparent;vertical-align:top;font-weight:bold;float:left">
         </span>&nbsp;&nbsp;
         <span id="_ref" style="width:70px;height:17px;background-color:transparent;color:#B6B3AA;font:13px arial,sans-serif;border:1px solid #fff;vertical-align:top;font-weight:bold;float:left">
         </span>
         <button id="zoom" style="width:15px !important" onclick="if(vm.currentMedia)vm.openViewer()">+
         </button>
      </span>
   </div>
   <table cellspacing=0 cellpadding=0 style="position:absolute;top:285px;width:461px;height:346px;margin-left:640px;background-color:transparent">
      <tr valign="middle">
         <td align="center" style="background-color:transparent">
            <div align="center" id="resource">
            </div>
         </td>
      </tr>
   </table>

   <div id="description" align="left"  style="display:block;position:absolute;top:635px;width:461px;height:80px;margin-left:640px;color:#B6B3AA;font:13px arial,sans-serif;">
   </div>
   <div align="left">
      <img style="position:absolute;top:635px" src="<?php echo Config::get('URL'); ?>img/key_safety.png"/>
   </div>
</div>
<script>
function pod(parent,data,server,index){
  var self=this;
  this.parent=parent;
  this.data=data;
  this.server=server;
  this.index=index;
  try{
  this.container=$('<div/>');
  this.container.css({position:'absolute',top:0,left:0,height:41,width:41});
  this.container.appendTo($(parent));
  }
  catch(e){
    alert(e);
  }
  this.pod=$('<div/>');
  this.pod.addClass('pod');
  this.pod.css({position:'absolute',top:0,left:0,height:'100%',width:'100%'});
  this.pod.appendTo(self.container);
  this.inner=$('<div/>');
  this.inner.addClass('pod');
  this.inner.css({position:'absolute',top:0,left:0,height:'100%',width:'100%'});
  this.inner.appendTo(self.pod);
  this.point=$('<img/>');
  this.point.addClass('point');
  this.point.css({position:'absolute',top:16,left:16,border:0});
  this.point.attr('src','<?php echo Config::get('URL'); ?>img/configuration/point.png');
  this.point.appendTo(self.pod);
  this.settings=$('<div/>');
  this.settings.css({width:520,height:410,'font-size':'12px',overflow:'none'});
  this.settings.appendTo("body");
  $(this.settings).dialog({
     modal:true,
     width:'auto',
     height:'auto',
     autoOpen:false,
     resizable:false,
     draggable:false,
     zIndex:200000,
     open:function(){
        self.viewtypes[currentViewtype].getSettings();
        $(self.settings).find('option').css({color:'#000'});
        vm.fmoverlay.show();
        $(this).dialog('option', 'position', 'center');
     },
     beforeClose:function(){
        self.viewtypes[currentViewtype].removeEvents();
     },
     close:function(){
        vm.fmoverlay.hide();
     },
     buttons: {
        'done': function() {
           $(this).dialog('close');
        }
     }
  })

  this.render=Raphael(self.inner[0]);
  self.render.customAttributes.arc = function (xloc, yloc, value, total, R) {
      var alpha = (360 / total * value),
         a = (90 - alpha) * Math.PI / 180,
         x = xloc + R * Math.cos(a),
         y = yloc - R * Math.sin(a),
         path;
      if (total == value) {
         path = [
            ["M", xloc, yloc - R],
            ["A", R, R, 0, 1, 1, xloc - 0.01, yloc - R]
         ];
      }
      else {
         path = [
            ["M", xloc, yloc - R],
            ["A", R, R, 0, +(alpha > 180), 1, x, y]
        ];
      }
      return {
         path: path
      };
   };

   self.render.customAttributes.name=function(name){
     return name
   }

  this.shadeColor=function(color, percent) {
     var num = parseInt(color.slice(1),16), amt = Math.round(2.55 * percent), R = (num >> 16) + amt, G = (num >> 8 & 0x00FF) + amt, B = (num & 0x0000FF) + amt;
     return "#" + (0x1000000 + (R<255?R<1?0:R:255)*0x10000 + (G<255?G<1?0:G:255)*0x100 + (B<255?B<1?0:B:255)).toString(16).slice(1);
  }

  this.viewtypes={
     "common": new commonView(self),
     "safety": new safetyView(self)
  }


  this.changeViewType=function(viewtype){
    self.render.clear();
    self.inner.unbind();
    self.viewtypes[viewtype].render();
    currentViewtype=viewtype;
    $(self.settings).dialog('option', 'title', currentViewtype.capitalize()+ " Settings for "+self.viewtypes.common.data.ssiid);
  }

  this.deserialize=function(){
     if(this.line)this.line.remove();
     this.pod.css({top:self.data.top,left:self.data.left});
     this.point.css({top:self.data.ptop,left:self.data.pleft});
     var start=this.pod.position();
     var end=this.point.position();
     this.pointx=((start.left+20)+((end.left+5)-20));
     this.pointy=((start.top+20)+((end.top+5)-20));
     this.line=vm.vector.path("M"+(start.left+20)+" "+(start.top+20)+"L"+((start.left+20)+((end.left+5)-20))+" "+((start.top+20)+((end.top+5)-20))).attr({stroke: "#FFFFFF"});
     this.outside=true;
     for(i in self.viewtypes){
        self.viewtypes[i].deserialize();
     }

  }

  $(self.pod).mousedown(function(){
     if(vm.selectedPod)$(vm.selectedPod.inner).css({'outline':'none'});
     vm.selectedPod=self;
     $(self.inner).css({'outline':'1px dotted #FFF '});
  });

  $(self.point).mousedown(function(){
     if(vm.selectedPod)$(vm.selectedPod.inner).css({'outline':'none'});
     vm.selectedPod=self;
     self.inner.click();
     $(self.inner).css({'outline':'1px dotted #FFF '});
  });


  //get initial view
  var currentViewtype="safety";
  self.changeViewType(currentViewtype);
}

function commonView(pod){
   var self=this;
   this.width=550;
   this.data={};
   this.data.ssiid='Unassigned';
   this.data.ref="";
   this.data.title="";
   this.data.SA="";
   this.data.SA2="";
   this.data.SB="";
   this.data.SC="";
   this.data.SD="";
   this.data.SE="";
   this.data.SF="";
   this.data.SG=0;
   this.data.SH=0;
   this.data.SI=0;
   this.data.SJ=0;
   this.render=function(){
      self.view=pod.render.circle(20,20,10).attr({fill:"#aaa",stroke:0});
      $('#indicator').css({background:self.view.attr('fill')});
      $(pod.inner).click(function(){
        vm.selectedPod=pod;
        self.setTitle();
        $('#_title').val(self.data.title).attr('title',self.data.title);
        $('#_ref').val(self.data.ref);
      }).
      dblclick(function(){
         $(vm.selectedPod.settings).dialog('open');
      })

      $('#resource').empty();
      $('#metrics').empty();
      $('#description').val('');
   }

   this.setTitle=function(){
      $(pod.inner).attr('title',self.data.ssiid);
   }

   this.getSettings=function(){
     var settings='<table width="100%"><tr valign="top"><td class="settings" width="30%"><h4>SSI ID: <span id="ssivalue">'+self.data.ssiid+'</span></h4><table>';
     settings+='<select id="ssisearch" style="width:auto;background:#fff;color:#000 !important">'+vm.ssiIds+'</select><br><br>';
     settings+='<table width="100%"><tr valign="top"><td class="settings" width="30%"><h4>Settings: <span id="rcminfo">RCM Version '+vm.rcmversion+'</span></h4><table>';
     settings+='<select id="rcmsearch" style="width:auto;background:#fff;color:#000 !important">'+vm.rcmSettings+'</select><br><br>';
     settings+='<table width="100%">';
     settings+='<tr><td>FM Reference (SA)</td><td><input class="SA" type="text" value="'+self.data.SA+'"/></td></tr>';
     settings+='<tr><td>FM Title (SA2)</td><td><textarea rows=2 class="SA2" type="text" value="'+self.data.SA2+'">'+self.data.SA2+'</textarea></td></tr>';
     settings+='<tr><td>Safety Or Operational (SB)</td><td><input class="SB" type="text" value="'+self.data.SB+'"/></td></tr>';
     settings+='<tr><td>Severity (SC)</td><td><input class="SC" type="text" value="'+self.data.SC+'"/></td></tr>';
     settings+='<tr><td>Probability (SD)</td><td><input class="SD" type="text" value="'+self.data.SD+'"/></td></tr>';
     settings+='<tr><td>Risk Class (SE)</td><td><input class="SE" type="text" value="'+self.data.SE+'"/></td></tr>';
     settings+='<tr><td>Hidden (SF)</td><td><input class="SF" type="text" value="'+self.data.SF+'"/></td></tr>';
     settings+='<tr><td>Safety Score Ref (SG)</td><td><input class="SG" type="text" value="'+self.data.SG+'"/></td></tr>';
     settings+='<tr><td>Operational Score Ref (SH)</td><td><input class="SH" type="text" value="'+self.data.SH+'"/></td></tr>';
     settings+='<tr><td>Max Possible Flaw Length (SI)</td><td><input class="SI" type="text" value="'+self.data.SI+'"/></td></tr>';
     settings+='<tr><td>Nominal Metal Thickness (SJ)</td><td><input class="SJ" type="text" value="'+self.data.SJ+'"/></td></tr>';
     settings+='</table>';
     pod.settings.html(settings);

     $('.settings input,.settings textarea').css({width:300,background:'#fff',color:'#000'});

     $('.settings #ssisearch').bind('change',function(){
        var id=this.value;
        self.data.ssiid=id;
        $(this).prev().find('span').html(id);
        self.setTitle();
     })

     $('.settings #rcmsearch').bind('change',function(){
        var rcmid=this.value;
        var map=new Array();
        map['SA']="RCM7";
        map['SA2']="RCM7A";
        map['SB']="RCM13";
        map['SC']="RCM15";
        map['SD']="RCM16";
        map['SE']="RCM17";
        map['SF']="RCM14";
        map['SG']="RCM26";
        map['SH']="RCM27";
        map['SI']="RCM28";
        map['SJ']="RCM31";
        $.post("<?php echo Config::get('URL'); ?>admin/getrcmrecord",{rcmid:rcmid},function(data){
           for(i in map){
              $('.settings .'+i).val(data[map[i]]);
              self.data[i]=data[map[i]];
           }
           self.data.title=data['RCM7A'];
           self.data.ref=data['RCM7'];
           $(pod.inner).click();
        },'json')
     })

     if(vm.buttonmode==1)$('.settings input,.settings textarea,.settings select').attr('disabled',false).css({'opacity':1});
     else $('.settings input,.settings textarea,.settings select').attr('disabled',true).css({'opacity':0.5});

   }

   this.removeEvents=function(){
       $('.settings #ssisearch').unbind();
       $('.settings #rcmsearch').unbind();
      // pod.inner.unbind();
   }

   this.serialize=function(){
      return JSON.stringify(self.data);
   }

   this.deserialize=function(){
      $.each( self.data, function( key, value ) {
         self.data[key]=(pod.data.common===undefined)?self.data[key]:pod.data.common[key];
      })
      $(pod.inner).attr('title',pod.viewtypes.common.data.ssiid);
   }


}

function safetyView(pod){
   var self=this;
   this.data={};
   this.data.pre={};
   this.data.pre.class="Unassigned";
   this.data.pre.media="img/configuration/nomedia.jpg";
   this.data.pre.description="";
   this.data.post={};
   this.data.post.class="Unassigned";
   this.data.post.media="img/configuration/nomedia.jpg";
   this.data.post.description="";



   this.render=function(){
      self.view=pod.render.circle(20,20,15).attr({fill:"#fff",stroke:0});
      $(pod.inner).click(function(){
         $('#_title').html(pod.viewtypes.common.data.title).attr('title',pod.viewtypes.common.data.title);
         $('#_ref').html(pod.viewtypes.common.data.ref);
      })
      $('#indicator').css({background:self.view.attr('fill')});
      self.all=pod.render.set();
      self.pre=self.drawarc(self.map[self.data.pre.class],9,9,180,'pre');
      self.all.push(self.pre);
      self.post=self.drawarc(self.map[self.data.post.class],9,9,0,'post');
      self.all.push(self.post);

   }

   this.map={"Unassigned":"#ccc","A":"#F85256","B":"#F8A152","C":"#F8E852","D":"#61F852"};
   this.drawarc=function(color,width,radius,rotate,name){
      return pod.render.path().attr({
      "cursor": "pointer",
      "stroke": color,
      "stroke-width": width,
      arc: [20, 20, 30, 60,radius ],
      "name":[name]

   })
   .rotate(rotate,20,20)
   .click(function(){
      self.selectedSegment=this.attr('name');
      $('#indicator').css({background:self[this.attr('name')].attr('stroke')});
      var resource=vm.rm.getResource(self.data[this.attr('name')].media)
      vm.currentMedia=resource;
      $('#resource').html('<a href="'+resource+'"><img src="ajaxLoading.gif"/></a>');
      $('#resource a').media({width:461,height:346, autoplay: true });
      self.showDescription();
   })
   }

   this.updateDescription=function(description){
      if(self.selectedSegment)self.data[self.selectedSegment].description=description;
   }

   this.showDescription=function(){
      if(self.selectedSegment)$('#description').html(self.data[self.selectedSegment].description);
   }

   this.updateMedia=function(media){
      if(self.selectedSegment)self.data[self.selectedSegment].media=media;
   }

   this.updateClass=function(riskclass){
      if(self.selectedSegment){
         self.data[self.selectedSegment].class=riskclass;
         self[self.selectedSegment].attr('stroke',self.map[riskclass]);
         $('#indicator').css({background:self.map[riskclass]});
      }

   }

   this.serialize=function(){
      return JSON.stringify(self.data);
   }

   this.deserialize=function(){
      $.each( self.data, function( key, value ) {
         self.data[key]=(pod.data.safety===undefined)?self.data[key]:pod.data.safety[key];
      })
   }
}

</script>